--TEST--
Bug #68199 (PDO::pgsqlGetNotify doesn't support NOTIFY payloads)
--EXTENSIONS--
pdo_pgsql
--SKIPIF--
<?php
require __DIR__ . '/config.inc';
require __DIR__ . '/../../../ext/pdo/tests/pdo_test.inc';
PDOTest::skip();

$db = PDOTest::factory();
if (version_compare($db->getAttribute(PDO::ATTR_SERVER_VERSION), '9.0.0') < 0) {
    die("skip Requires 9.0+");
}

?>
--FILE--
<?php
require __DIR__ . '/../../../ext/pdo/tests/pdo_test.inc';
$db = PDOTest::test_factory(__DIR__ . '/common.phpt');
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// pgsqlGetPid should return something meaningful
$pid = $db->pgsqlGetPid();
var_dump($pid > 0);

// No listen, no notifies
var_dump($db->pgsqlGetNotify());

// Listen started, no notifies
$db->exec("LISTEN channel_bug68199");
var_dump($db->pgsqlGetNotify());

// No parameters with payload, use default PDO::FETCH_NUM
$db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_NUM);
$db->exec("NOTIFY channel_bug68199, 'payload'");
$notify = $db->pgsqlGetNotify();
var_dump(count($notify));
var_dump($notify[0]);
var_dump($notify[1] == $pid);
var_dump($notify[2]);

// No parameters with payload, use default PDO::FETCH_ASSOC
$db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
$db->exec("NOTIFY channel_bug68199, 'payload'");
$notify = $db->pgsqlGetNotify();
var_dump(count($notify));
var_dump($notify['message']);
var_dump($notify['pid'] == $pid);
var_dump($notify['payload']);

// Test PDO::FETCH_NUM as parameter with payload
$db->exec("NOTIFY channel_bug68199, 'payload'");
$notify = $db->pgsqlGetNotify(PDO::FETCH_NUM);
var_dump(count($notify));
var_dump($notify[0]);
var_dump($notify[1] == $pid);
var_dump($notify[2]);

// Test PDO::FETCH_ASSOC as parameter with payload
$db->exec("NOTIFY channel_bug68199, 'payload'");
$notify = $db->pgsqlGetNotify(PDO::FETCH_ASSOC);
var_dump(count($notify));
var_dump($notify['message']);
var_dump($notify['pid'] == $pid);
var_dump($notify['payload']);

// Test PDO::FETCH_BOTH as parameter with payload
$db->exec("NOTIFY channel_bug68199, 'payload'");
$notify = $db->pgsqlGetNotify(PDO::FETCH_BOTH);
var_dump(count($notify));
var_dump($notify['message']);
var_dump($notify['pid'] == $pid);
var_dump($notify['payload']);
var_dump($notify[0]);
var_dump($notify[1] == $pid);
var_dump($notify[2]);

// Verify that there are no notifies queued
var_dump($db->pgsqlGetNotify());

?>
--EXPECTF--
Deprecated: Method PDO::pgsqlGetPid() is deprecated since 8.5, use Pdo\Pgsql::getPid() instead in %s on line %d
bool(true)

Deprecated: Method PDO::pgsqlGetNotify() is deprecated since 8.5, use Pdo\Pgsql::getNotify() instead in %s on line %d
bool(false)

Deprecated: Method PDO::pgsqlGetNotify() is deprecated since 8.5, use Pdo\Pgsql::getNotify() instead in %s on line %d
bool(false)

Deprecated: Method PDO::pgsqlGetNotify() is deprecated since 8.5, use Pdo\Pgsql::getNotify() instead in %s on line %d
int(3)
string(16) "channel_bug68199"
bool(true)
string(7) "payload"

Deprecated: Method PDO::pgsqlGetNotify() is deprecated since 8.5, use Pdo\Pgsql::getNotify() instead in %s on line %d
int(3)
string(16) "channel_bug68199"
bool(true)
string(7) "payload"

Deprecated: Method PDO::pgsqlGetNotify() is deprecated since 8.5, use Pdo\Pgsql::getNotify() instead in %s on line %d
int(3)
string(16) "channel_bug68199"
bool(true)
string(7) "payload"

Deprecated: Method PDO::pgsqlGetNotify() is deprecated since 8.5, use Pdo\Pgsql::getNotify() instead in %s on line %d
int(3)
string(16) "channel_bug68199"
bool(true)
string(7) "payload"

Deprecated: Method PDO::pgsqlGetNotify() is deprecated since 8.5, use Pdo\Pgsql::getNotify() instead in %s on line %d
int(6)
string(16) "channel_bug68199"
bool(true)
string(7) "payload"
string(16) "channel_bug68199"
bool(true)
string(7) "payload"

Deprecated: Method PDO::pgsqlGetNotify() is deprecated since 8.5, use Pdo\Pgsql::getNotify() instead in %s on line %d
bool(false)
