--TEST--
Test array_diff() function : usage variations  - array with different data types as values
--FILE--
<?php
/*
 * Test how array_diff() compares indexed arrays containing different
 * data types as values in place of $arr2
 */

echo "*** Testing array_diff() : usage variations ***\n";

// Initialise function arguments not being substituted (if any)
$array = array(1, 2);

//array of values to iterate over
$values = array(

/*1*/"empty array" => array(),

/*2*/
"int" => array(
      // int data
      0,
      1,
      12345,
      -2345),

/*3*/
"float" => array(
      // float data
       10.5,
       -10.5,
       12.3456789000e10,
       12.3456789000E-10,
       .5),

/*4*/
"null" => array(
      // null data
      null),

/*5*/
"boolean" => array(
      // boolean data
      true,
      false),

/*6*/
"empty" => array(
      // empty data
      ''),

/*7*/
"string" => array(
      // string data
      'string'),
);

// loop through each element of the array for $arr2
$iterator = 1;
foreach($values as $value) {
      echo "\n Iteration: $iterator \n";
      var_dump( array_diff($array, $value) );
      $iterator++;
};

echo "Done";
?>
--EXPECT--
*** Testing array_diff() : usage variations ***

 Iteration: 1 
array(2) {
  [0]=>
  int(1)
  [1]=>
  int(2)
}

 Iteration: 2 
array(1) {
  [1]=>
  int(2)
}

 Iteration: 3 
array(2) {
  [0]=>
  int(1)
  [1]=>
  int(2)
}

 Iteration: 4 
array(2) {
  [0]=>
  int(1)
  [1]=>
  int(2)
}

 Iteration: 5 
array(1) {
  [1]=>
  int(2)
}

 Iteration: 6 
array(2) {
  [0]=>
  int(1)
  [1]=>
  int(2)
}

 Iteration: 7 
array(2) {
  [0]=>
  int(1)
  [1]=>
  int(2)
}
Done
