#ifndef CONFIG_W32_H
#define CONFIG_W32_H

/*
	Build Configuration Template for Win32.
*/

/* Define the minimum supported version */
#undef _WIN32_WINNT
#undef NTDDI_VERSION
#define _WIN32_WINNT 0x0602
#define NTDDI_VERSION 0x06020000

/* Default PHP / PEAR directories */
#define PHP_CONFIG_FILE_PATH ""
#define PEAR_INSTALLDIR "C:\\php\\pear"
#define PHP_BINDIR "C:\\php"
#define PHP_SBINDIR "C:\\php"
#define PHP_DATADIR "C:\\php"
#define PHP_EXTENSION_DIR "C:\\php\\ext"
#define PHP_INCLUDE_PATH	".;C:\\php\\pear"
#define PHP_LIBDIR "C:\\php"
#define PHP_LOCALSTATEDIR "C:\\php"
#define PHP_PREFIX "C:\\php"
#define PHP_SYSCONFDIR "C:\\php"

/* PHP Runtime Configuration */
#define DEFAULT_SHORT_OPEN_TAG "1"

/* Platform-Specific Configuration. Should not be changed. */
/* Alignment for Zend memory allocator */
#define ZEND_MM_ALIGNMENT (size_t)8
#define ZEND_MM_ALIGNMENT_LOG2 (size_t)3
#define ZEND_MM_NEED_EIGHT_BYTE_REALIGNMENT 0
#define PHP_SIGCHILD 0
#define HAVE_GETSERVBYNAME 1
#define HAVE_GETSERVBYPORT 1
#define HAVE_GETPROTOBYNAME 1
#define HAVE_GETPROTOBYNUMBER 1
#define HAVE_GETHOSTNAME 1
#define STDIN_FILENO 0
#define STDOUT_FILENO 1
#define STDERR_FILENO 2
#undef HAVE_ADABAS
#undef HAVE_SOLID
#undef HAVE_SYMLINK

/* its in win32/time.c */
#define HAVE_USLEEP 1
#define HAVE_NANOSLEEP 1

#define HAVE_GETCWD 1
#undef HAVE_SETITIMER
#undef HAVE_IODBC
#define HAVE_LIBDL 1
#define HAVE_GETTIMEOFDAY 1
#define HAVE_PUTENV 1
#define HAVE_TZSET 1
#undef HAVE_FLOCK
#define HAVE_ALLOCA 1
#undef HAVE_SYS_TIME_H
#undef HAVE_STRUCT_STAT_ST_BLKSIZE
#undef HAVE_STRUCT_STAT_ST_BLOCKS
#define HAVE_STRUCT_STAT_ST_RDEV 1
#define HAVE_SHUTDOWN 1
#define HAVE_STRCASECMP 1
#define HAVE_UTIME 1
#undef HAVE_DIRENT_H
#define HAVE_FCNTL_H 1
#undef HAVE_GRP_H
#undef HAVE_PWD_H
#undef HAVE_SYS_FILE_H
#undef HAVE_SYS_SOCKET_H
#undef HAVE_SYS_WAIT_H
#define HAVE_SYSLOG_H 1
#undef HAVE_UNISTD_H
#define HAVE_SYS_TYPES_H 1
#undef HAVE_ALLOCA_H
#undef HAVE_KILL
#define HAVE_GETPID 1
/* int and long are still 32bit in 64bit compiles */
#define SIZEOF_INT 4
#define SIZEOF_LONG 4
/* MSVC.6/NET don't allow 'long long' */
#define SIZEOF_LONG_LONG 8 /* defined as __int64 */
#define ssize_t SSIZE_T
#ifdef _WIN64
# define SIZEOF_SIZE_T 8
#else
# define SIZEOF_SIZE_T 4
#endif
#define SIZEOF_OFF_T 4
#define HAVE_FNMATCH
#define PHP_SHLIB_SUFFIX "dll"
#define PHP_SHLIB_EXT_PREFIX "php_"

/* Win32 supports socketpair by the emulation in win32/sockets.c */
#define HAVE_SOCKETPAIR 1
#define HAVE_SOCKLEN_T 1

/* Win32 support proc_open */
#define PHP_CAN_SUPPORT_PROC_OPEN 1

/* vs.net 2005 has a 64-bit time_t.  This will likely break
 * 3rdParty libs that were built with older compilers; switch
 * back to 32-bit */
#ifndef _WIN64
# define _USE_32BIT_TIME_T 1
#endif

#define _REENTRANT 1

#define HAVE_GETRUSAGE

#define HAVE_FTOK 1

#define HAVE_NICE

#ifdef __clang__
#define HAVE_FUNC_ATTRIBUTE_TARGET 1
#endif

#define HAVE_GETADDRINFO 1

/* values determined by configure.js */

/* The system that PHP was built on. */
#define PHP_BUILD_SYSTEM "Microsoft Windows Server 2022 Datacenter [10.0.20348]"

/* Configure line */
#define CONFIGURE_COMMAND "cscript /nologo /e:jscript configure.js  \"--enable-snapshot-build\"" " \"--enable-debug-pack\" \"--disable-zts\" \"--enable-object-out-dir=../obj/\"" " \"--enable-com-dotnet=shared\" \"--without-analyzer\" \"--with-pgo\""

/* The compiler used for the PHP build. */
#define PHP_BUILD_COMPILER "Visual C++ 2022"

/* Compiler compatibility ID */
#define PHP_COMPILER_ID "VS17"

/* The build architecture. */
#define PHP_BUILD_ARCH "x86"

/* Linker major version */
#define PHP_LINKER_MAJOR 14

/* Linker minor version */
#define PHP_LINKER_MINOR 44

#define HAVE_STRNLEN 1

#define ZEND_CHECK_STACK_LIMIT 1

#define HAVE_GAI_STRERROR 1

#define HAVE_IPV6 1

#define __SSE__ 1

#define __SSE2__ 1

/* Define to 1 if the PHP extension 'bcmath' is available. */
#define HAVE_BCMATH 1

/* Define to 1 if the PHP extension 'calendar' is available. */
#define HAVE_CALENDAR 1

/* Define to 1 if the PHP extension 'com_dotnet' is available. */
#define HAVE_COM_DOTNET 1

/* Define to 1 if the PHP extension 'ctype' is available. */
#define HAVE_CTYPE 1

/* Define to 1 if you have the <timelib_config.h> header file. */
#define HAVE_TIMELIB_CONFIG_H 1

/* Define to 1 if the PHP extension 'dba' is available. */
#define HAVE_DBA 1

/* Define to 1 if the PHP extension 'ftp' is available. */
#define HAVE_FTP 1

/* Define to 1 if mhash support is enabled. */
#define PHP_MHASH_BC 1

/* Define to 1 if the PHP extension 'lexbor' is available. */
#define HAVE_LEXBOR 1

/* Define the main Lexbor version */
#define LEXBOR_VERSION "2.5.0"

/* Define to 1 if the PHP extension 'odbc' is available. */
#define HAVE_UODBC 1

/* Define to 1 if ODBC library has 'SQLDataSources', as a function or macro. */
#define HAVE_SQLDATASOURCES 1

/* Define to 1 if PHP uses the bundled PCRE library. */
#define HAVE_BUNDLED_PCRE 1

/* Number of bits in non-UTF mode for PCRE library. */
#define PCRE2_CODE_UNIT_WIDTH 8

/* Define to 1 if PCRE library is built statically. */
#define PCRE2_STATIC 1

/* Define to 1 if PCRE JIT is enabled and supported. */
#define HAVE_PCRE_JIT_SUPPORT 1

/* Define to 1 if the PHP extension 'shmop' is available. */
#define HAVE_SHMOP 1

/* Define to 1 if the PHP extension 'sockets' is available. */
#define HAVE_SOCKETS 1

#define PHP_CONFIG_FILE_SCAN_DIR ""

/* Define to 1 if PHP uses its own crypt_r, and to 0 if using the external crypt library. */
#define PHP_USE_PHP_CRYPT_R 1

/* Define to 1 if the PHP extension 'sysvshm' is available. */
#define HAVE_SYSVSHM 1

/* Define to 1 if the PHP extension 'mbstring' is available. */
#define HAVE_MBSTRING 1

/* Define to 1 if the PHP extension 'exif' is available. */
#define HAVE_EXIF 1

/* Define to 1 to enable JIT. */
#define HAVE_JIT 1

/* Define to 1 if the pdo_mysql extension uses mysqlnd. */
#define PDO_USE_MYSQLND 1

/* Define to 1 if the PHP extension 'session' is available. */
#define HAVE_PHP_SESSION 1

/* Define to 1 for enabling ANSI support of uriparser. */
#define URI_ENABLE_ANSI 1

/* Define to 1 for disabling unicode support of uriparser. */
#define URI_NO_UNICODE 1

#if __has_include("main/config.pickle.h")
#include "main/config.pickle.h"
#endif

#endif /* CONFIG_W32_H */
