/* Generated by re2c 0.13.5 on Tue May 19 08:53:54 2009 */
#line 1 "Zend/zend_ini_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2009 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id: zend_ini_scanner.c,v 1.1.2.18 2009/05/19 15:59:36 shire Exp $ */

#include <errno.h>
#include "zend.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    YYCURSOR = yytext + x
/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6
#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng > 0 && (                          \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len) {  \
	Z_STRVAL_P(retval) = zend_strndup(str, len); \
	Z_STRLEN_P(retval) = len;                    \
	Z_TYPE_P(retval) = IS_STRING;                \
}

#define RETURN_TOKEN(type, str, len) {           \
	zend_ini_copy_value(ini_lval, str, len);     \
	return type;                                 \
}

static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static void init_ini_scanner(TSRMLS_D)
{
	SCNG(lineno) = 1;
	SCNG(scanner_mode) = ZEND_INI_SCANNER_NORMAL;
	zend_stack_init(&SCNG(state_stack));
	BEGIN(INITIAL);
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(TSRMLS_D)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
int zend_ini_scanner_get_lineno(TSRMLS_D)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
char *zend_ini_scanner_get_filename(TSRMLS_D)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode TSRMLS_DC)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	init_ini_scanner(TSRMLS_C);
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;
	yy_scan_buffer(buf, size TSRMLS_CC);
	ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode TSRMLS_DC)
{
	int len = strlen(str);

	init_ini_scanner(TSRMLS_C);
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = NULL;
	yy_scan_buffer(str, len TSRMLS_CC);
	ini_filename = NULL;
	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return 0;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

#line 305 "Zend/zend_ini_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 160,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			160, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 192, 128, 128, 192, 192, 128, 
			192, 192, 192, 192, 192, 192, 192, 192, 
			192, 192, 128, 128, 128, 128, 128, 128, 
			128, 192, 192, 192, 192, 192, 192, 192, 
			192, 192, 192, 192, 192, 192, 192, 192, 
			192, 192, 192, 192, 192, 192, 192, 192, 
			192, 192, 192, 128, 128, 128, 128, 192, 
			128, 192, 192, 192, 192, 192, 192, 192, 
			192, 192, 192, 192, 192, 192, 192, 192, 
			192, 192, 192, 192, 192, 192, 192, 192, 
			192, 192, 192, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case '\t':
		case ' ':	goto yy5;
		case '\n':	goto yy7;
		case '\r':	goto yy9;
		case '!':
		case '"':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '+':
		case ',':
		case '/':
		case ':':
		case '<':
		case '>':
		case '?':
		case '@':
		case ']':
		case '^':
		case '{':
		case '|':
		case '}':
		case '~':	goto yy10;
		case '#':	goto yy12;
		case '*':
		case '-':
		case '.':	goto yy13;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy14;
		case ';':	goto yy15;
		case '=':	goto yy16;
		case 'F':
		case 'f':	goto yy18;
		case 'N':
		case 'n':	goto yy19;
		case 'O':
		case 'o':	goto yy20;
		case 'T':
		case 't':	goto yy21;
		case 'Y':
		case 'y':	goto yy22;
		case '[':	goto yy23;
		default:	goto yy3;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 389 "Zend/zend_ini_scanner.l"
		{ /* Get option name */
	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
#line 486 "Zend/zend_ini_scanner.c"
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 502 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 496 "Zend/zend_ini_scanner.c"
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy63;
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 474 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 510 "Zend/zend_ini_scanner.c"
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 479 "Zend/zend_ini_scanner.l"
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 522 "Zend/zend_ini_scanner.c"
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy61;
		goto yy8;
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 429 "Zend/zend_ini_scanner.l"
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
#line 537 "Zend/zend_ini_scanner.c"
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy57;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy29;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy29;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy52;
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy50;
yy17:
		YYDEBUG(17, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 393 "Zend/zend_ini_scanner.l"
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW TSRMLS_CC);
	} else {
		yy_push_state(ST_VALUE TSRMLS_CC);
	}
	return '=';
}
#line 573 "Zend/zend_ini_scanner.c"
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy46;
		if (yych == 'a') goto yy46;
		goto yy29;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy42;
			if (yych <= 'T') goto yy29;
			goto yy43;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy29;
				goto yy42;
			} else {
				if (yych == 'u') goto yy43;
				goto yy29;
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy37;
			if (yych <= 'M') goto yy29;
			goto yy31;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy29;
				goto yy37;
			} else {
				if (yych == 'n') goto yy31;
				goto yy29;
			}
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy35;
		if (yych == 'r') goto yy35;
		goto yy29;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy30;
		if (yych == 'e') goto yy30;
		goto yy29;
yy23:
		YYDEBUG(23, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 32) {
			goto yy25;
		}
		YYDEBUG(24, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 327 "Zend/zend_ini_scanner.l"
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW TSRMLS_CC);
	} else {
		yy_push_state(ST_SECTION_VALUE TSRMLS_CC);
	}
	return TC_SECTION;
}
#line 642 "Zend/zend_ini_scanner.c"
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy25;
		}
		YYDEBUG(27, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 352 "Zend/zend_ini_scanner.l"
		{ /* Start of option with offset */
	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET TSRMLS_CC);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
#line 664 "Zend/zend_ini_scanner.c"
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy29:
		YYDEBUG(29, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy28;
		}
		if (yych == '[') goto yy25;
		goto yy2;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy31;
		if (yych != 's') goto yy29;
yy31:
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 64) {
			goto yy28;
		}
		if (yych == '[') goto yy25;
		goto yy34;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 381 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 697 "Zend/zend_ini_scanner.c"
yy33:
		YYDEBUG(33, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy34:
		YYDEBUG(34, *YYCURSOR);
		if (yych == '\t') goto yy33;
		if (yych == ' ') goto yy33;
		goto yy32;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy36;
		if (yych != 'u') goto yy29;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy31;
		if (yych == 'e') goto yy31;
		goto yy29;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy38;
		if (yych != 'f') goto yy29;
yy38:
		YYDEBUG(38, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 64) {
			goto yy28;
		}
		if (yych == '[') goto yy25;
		goto yy41;
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 385 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 739 "Zend/zend_ini_scanner.c"
yy40:
		YYDEBUG(40, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy41:
		YYDEBUG(41, *YYCURSOR);
		if (yych == '\t') goto yy40;
		if (yych == ' ') goto yy40;
		goto yy39;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych <= '.') {
				if (yych == '*') goto yy28;
				if (yych <= ',') goto yy41;
				goto yy28;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy41;
					goto yy28;
				} else {
					if (yych <= '@') goto yy41;
					if (yych <= 'M') goto yy28;
					goto yy45;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy28;
				if (yych <= '[') goto yy25;
				if (yych <= '^') goto yy41;
				goto yy28;
			} else {
				if (yych <= 'm') {
					if (yych <= '`') goto yy41;
					goto yy28;
				} else {
					if (yych <= 'n') goto yy45;
					if (yych <= 'z') goto yy28;
					goto yy41;
				}
			}
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy44;
		if (yych != 'l') goto yy29;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy38;
		if (yych == 'l') goto yy38;
		goto yy29;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy38;
		if (yych == 'e') goto yy38;
		goto yy29;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy47;
		if (yych != 'l') goto yy29;
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy48;
		if (yych != 's') goto yy29;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy38;
		if (yych == 'e') goto yy38;
		goto yy29;
yy49:
		YYDEBUG(49, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy50:
		YYDEBUG(50, *YYCURSOR);
		if (yych == '\t') goto yy49;
		if (yych == ' ') goto yy49;
		goto yy17;
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy52:
		YYDEBUG(52, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy51;
		}
		if (yych >= '\r') goto yy55;
yy53:
		YYDEBUG(53, *YYCURSOR);
		++YYCURSOR;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 484 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 851 "Zend/zend_ini_scanner.c"
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy53;
		goto yy54;
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy57:
		YYDEBUG(57, *YYCURSOR);
		if (yych == '\n') goto yy58;
		if (yych == '\r') goto yy60;
		goto yy56;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 490 "Zend/zend_ini_scanner.l"
		{ /* #Comment */
	zend_error(E_DEPRECATED, "Comments starting with '#' are deprecated in %s on line %d", zend_ini_scanner_get_filename(TSRMLS_C), SCNG(lineno));
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 880 "Zend/zend_ini_scanner.c"
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy58;
		goto yy59;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy8;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy63:
		YYDEBUG(63, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy6;
				if (yych <= '\t') goto yy62;
				goto yy61;
			} else {
				if (yych == '\r') goto yy64;
				if (yych <= 0x1F) goto yy6;
				goto yy62;
			}
		} else {
			if (yych <= ':') {
				if (yych == '#') goto yy56;
				goto yy6;
			} else {
				if (yych <= ';') goto yy51;
				if (yych == '=') goto yy49;
				goto yy6;
			}
		}
yy64:
		YYDEBUG(64, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy61;
		goto yy8;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16, 144,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			144,  16,   0,  16,  32,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  64,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(65, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy69;
		} else {
			if (yych <= '$') goto yy71;
			if (yych == '\\') goto yy73;
		}
		YYDEBUG(67, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy77;
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 456 "Zend/zend_ini_scanner.l"
		{ /* Escape double quoted string contents */
	if(yyleng > 1 && yytext[yyleng-1] == '"' && yytext[yyleng-2] == '\\') {
		yyless(yyleng-1);
		yyleng--;
	}
	zend_ini_escape_string(ini_lval, yytext, yyleng, '"' TSRMLS_CC);
	return TC_QUOTED_STRING;
}
#line 986 "Zend/zend_ini_scanner.c"
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy91;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 465 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string ends */
	yy_pop_state(TSRMLS_C);
	return '"';
}
#line 1000 "Zend/zend_ini_scanner.c"
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '\\') {
			if (yych <= 0x00) goto yy72;
			if (yych <= '[') goto yy76;
			goto yy80;
		} else {
			if (yych == '{') goto yy88;
			goto yy76;
		}
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 502 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1019 "Zend/zend_ini_scanner.c"
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '"') goto yy76;
		YYDEBUG(74, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy75;
		if (yych != '\r') goto yy76;
yy75:
		YYDEBUG(75, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 0) {
			goto yy68;
		} else {
			goto yy72;
		}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy77:
		YYDEBUG(77, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy76;
		}
		if (yych <= '#') goto yy68;
		if (yych <= '$') goto yy79;
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '"') goto yy85;
		goto yy76;
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy75;
			if (yych <= '[') goto yy76;
		} else {
			if (yych == '{') goto yy75;
			goto yy76;
		}
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy81;
		}
		if (yych == '\\') goto yy83;
		goto yy76;
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy81;
		}
		if (yych == '\\') goto yy86;
		goto yy76;
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy76;
		}
		if (yych <= '#') goto yy85;
		if (yych <= '$') goto yy81;
		goto yy83;
yy85:
		YYDEBUG(85, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\n') goto yy68;
		if (yych == '\r') goto yy68;
		goto yy76;
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy76;
		}
		if (yych <= '#') goto yy87;
		if (yych <= '$') goto yy81;
		goto yy83;
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy81;
		}
		if (yych == '\\') goto yy83;
		goto yy76;
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 367 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 1140 "Zend/zend_ini_scanner.c"
yy90:
		YYDEBUG(90, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy91:
		YYDEBUG(91, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy90;
		}
		goto yy70;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66, 194,  64,  66,  66,  64,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			194,  66,  64,  66,  68,  66,  66,   0, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114,  66,  64,  66,  66,  66,  66, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  72,  64,  66,  82, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
		};
		YYDEBUG(92, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= ',') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy94;
					if (yych <= '\t') goto yy96;
					goto yy97;
				} else {
					if (yych == '\r') goto yy97;
					if (yych >= ' ') goto yy96;
				}
			} else {
				if (yych <= '#') {
					if (yych == '"') goto yy99;
				} else {
					if (yych <= '$') goto yy101;
					if (yych == '\'') goto yy102;
				}
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') {
					if (yych <= '-') goto yy103;
					if (yych <= '.') goto yy104;
				} else {
					if (yych <= '9') goto yy105;
					if (yych == ';') goto yy97;
				}
			} else {
				if (yych <= '\\') {
					if (yych <= 'Z') goto yy107;
					if (yych >= '\\') goto yy109;
				} else {
					if (yych <= ']') goto yy110;
					if (yych <= '`') goto yy94;
					if (yych <= 'z') goto yy107;
				}
			}
		}
yy94:
		YYDEBUG(94, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy113;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 447 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 1243 "Zend/zend_ini_scanner.c"
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy139;
		}
		if (yych == '"') goto yy141;
		if (yych == ']') goto yy142;
		goto yy113;
yy97:
		YYDEBUG(97, *YYCURSOR);
		++YYCURSOR;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 502 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1264 "Zend/zend_ini_scanner.c"
yy99:
		YYDEBUG(99, *YYCURSOR);
		++YYCURSOR;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 451 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 1276 "Zend/zend_ini_scanner.c"
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy98;
			if (yych <= '[') goto yy112;
			goto yy117;
		} else {
			if (yych == '{') goto yy137;
			goto yy112;
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy133;
		}
		goto yy98;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy113;
		if (yych <= '9') goto yy131;
		goto yy113;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy113;
		if (yych <= '9') goto yy129;
		goto yy113;
yy105:
		YYDEBUG(105, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy106;
				if (yych <= '\f') goto yy113;
			} else {
				if (yych == '"') goto yy106;
				if (yych <= '&') goto yy113;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy125;
				if (yych <= '/') goto yy113;
				goto yy127;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy113;
				} else {
					if (yych != ']') goto yy113;
				}
			}
		}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 425 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 1342 "Zend/zend_ini_scanner.c"
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy123;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy113;
			} else {
				if (yych <= '\r') goto yy108;
				if (yych <= '!') goto yy113;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy113;
			} else {
				if (yych <= ';') goto yy108;
				if (yych != ']') goto yy113;
			}
		}
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 421 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 1372 "Zend/zend_ini_scanner.c"
yy109:
		YYDEBUG(109, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy112;
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 362 "Zend/zend_ini_scanner.l"
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
#line 1388 "Zend/zend_ini_scanner.c"
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy113:
		YYDEBUG(113, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy112;
		}
		if (yych == '$') goto yy115;
		if (yych != '\\') goto yy95;
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy112;
yy115:
		YYDEBUG(115, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy116;
			if (yych <= '[') goto yy112;
			goto yy117;
		} else {
			if (yych != '{') goto yy112;
		}
yy116:
		YYDEBUG(116, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy95;
			} else {
				goto yy98;
			}
		} else {
			if (yyaccept <= 2) {
				goto yy106;
			} else {
				goto yy108;
			}
		}
yy117:
		YYDEBUG(117, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy118;
		}
		if (yych == '\\') goto yy120;
		goto yy112;
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(119, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy118;
		}
		if (yych == '\\') goto yy122;
		goto yy112;
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(121, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy118;
		}
		if (yych == '\\') goto yy120;
		goto yy112;
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy118;
		}
		if (yych == '\\') goto yy120;
		goto yy112;
yy123:
		YYDEBUG(123, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy123;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy108;
				if (yych <= '\f') goto yy112;
				goto yy108;
			} else {
				if (yych == '"') goto yy108;
				if (yych <= '#') goto yy112;
				goto yy115;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy108;
				if (yych <= ':') goto yy112;
				goto yy108;
			} else {
				if (yych <= '[') goto yy112;
				if (yych <= '\\') goto yy114;
				if (yych <= ']') goto yy108;
				goto yy112;
			}
		}
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(126, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy125;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy106;
				if (yych <= '\f') goto yy112;
				goto yy106;
			} else {
				if (yych == '"') goto yy106;
				if (yych <= '#') goto yy112;
				goto yy115;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy106;
				if (yych <= ':') goto yy112;
				goto yy106;
			} else {
				if (yych <= '[') goto yy112;
				if (yych <= '\\') goto yy114;
				if (yych <= ']') goto yy106;
				goto yy112;
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy112;
					goto yy106;
				} else {
					if (yych == '\r') goto yy106;
					goto yy112;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy106;
					goto yy112;
				} else {
					if (yych <= '$') goto yy115;
					if (yych <= '&') goto yy112;
					goto yy106;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy112;
					goto yy125;
				} else {
					if (yych <= '/') goto yy112;
					if (yych <= '9') goto yy127;
					goto yy112;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy106;
					goto yy112;
				} else {
					if (yych <= '\\') goto yy114;
					if (yych <= ']') goto yy106;
					goto yy112;
				}
			}
		}
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy106;
				if (yych <= '\f') goto yy112;
				goto yy106;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy112;
					goto yy106;
				} else {
					if (yych == '$') goto yy115;
					goto yy112;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy106;
				if (yych <= '/') goto yy112;
				if (yych <= '9') goto yy129;
				goto yy112;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy106;
					goto yy112;
				} else {
					if (yych <= '\\') goto yy114;
					if (yych <= ']') goto yy106;
					goto yy112;
				}
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(132, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy106;
				if (yych <= '\f') goto yy112;
				goto yy106;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy112;
					goto yy106;
				} else {
					if (yych == '$') goto yy115;
					goto yy112;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy106;
				if (yych <= '/') goto yy112;
				if (yych <= '9') goto yy131;
				goto yy112;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy106;
					goto yy112;
				} else {
					if (yych <= '\\') goto yy114;
					if (yych <= ']') goto yy106;
					goto yy112;
				}
			}
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(134, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy133;
		}
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 337 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1687 "Zend/zend_ini_scanner.c"
yy137:
		YYDEBUG(137, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 367 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 1698 "Zend/zend_ini_scanner.c"
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(140, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy139;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy95;
				if (yych <= '\f') goto yy112;
				goto yy95;
			} else {
				if (yych == '"') goto yy141;
				if (yych <= '#') goto yy112;
				goto yy115;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy95;
				if (yych <= ':') goto yy112;
				goto yy95;
			} else {
				if (yych <= '[') goto yy112;
				if (yych <= '\\') goto yy114;
				if (yych <= ']') goto yy142;
				goto yy112;
			}
		}
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy100;
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy111;
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 224,   0, 160, 160,   0, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			224, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160,  32, 160,  32, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
			160, 160, 160, 160, 160, 160, 160, 160, 
		};
		YYDEBUG(143, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy145;
				if (yych <= '\t') goto yy147;
				goto yy148;
			} else {
				if (yych == '\r') goto yy150;
			}
		} else {
			if (yych <= ';') {
				if (yych <= ' ') goto yy147;
				if (yych >= ';') goto yy151;
			} else {
				if (yych == '=') goto yy153;
			}
		}
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy164;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 402 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	/* Eat leading and trailing double quotes */
	if (yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1814 "Zend/zend_ini_scanner.c"
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy160;
		}
		if (yych <= '\f') {
			if (yych == '\n') goto yy159;
			goto yy164;
		} else {
			if (yych <= '\r') goto yy162;
			if (yych == ';') goto yy154;
			goto yy164;
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 415 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1842 "Zend/zend_ini_scanner.c"
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy159;
		goto yy149;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy155;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 497 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 1861 "Zend/zend_ini_scanner.c"
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy152;
yy154:
		YYDEBUG(154, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy155:
		YYDEBUG(155, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy154;
		}
		if (yych >= '\r') goto yy158;
yy156:
		YYDEBUG(156, *YYCURSOR);
		++YYCURSOR;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 484 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1889 "Zend/zend_ini_scanner.c"
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy156;
		goto yy157;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy149;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy160;
		}
		if (yych <= '\r') {
			if (yych == '\n') goto yy159;
			if (yych <= '\f') goto yy163;
		} else {
			if (yych <= ';') {
				if (yych <= ':') goto yy163;
				goto yy154;
			} else {
				if (yych == '=') goto yy146;
				goto yy163;
			}
		}
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy159;
		goto yy149;
yy163:
		YYDEBUG(163, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy164:
		YYDEBUG(164, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy163;
		}
		goto yy146;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 192,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			192, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(165, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\n') goto yy169;
		} else {
			if (yych <= '\r') goto yy169;
			if (yych == ']') goto yy171;
		}
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy178;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 411 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1995 "Zend/zend_ini_scanner.c"
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(170, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 502 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2005 "Zend/zend_ini_scanner.c"
yy171:
		YYDEBUG(171, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy174;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 346 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2020 "Zend/zend_ini_scanner.c"
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy174:
		YYDEBUG(174, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy173;
		}
		if (yych == '\n') goto yy175;
		if (yych == '\r') goto yy176;
		goto yy172;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy172;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy175;
		goto yy172;
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy178:
		YYDEBUG(178, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy177;
		}
		goto yy168;
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 134, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			134, 132, 128, 132, 136, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			228, 228, 228, 228, 228, 228, 228, 228, 
			228, 228, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 144, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(179, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= ',') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy181;
					if (yych <= '\t') goto yy183;
					goto yy184;
				} else {
					if (yych == '\r') goto yy184;
					if (yych >= ' ') goto yy183;
				}
			} else {
				if (yych <= '#') {
					if (yych == '"') goto yy186;
				} else {
					if (yych <= '$') goto yy188;
					if (yych == '\'') goto yy189;
				}
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') {
					if (yych <= '-') goto yy190;
					if (yych <= '.') goto yy191;
				} else {
					if (yych <= '9') goto yy192;
					if (yych == ';') goto yy184;
				}
			} else {
				if (yych <= '\\') {
					if (yych <= 'Z') goto yy194;
					if (yych >= '\\') goto yy196;
				} else {
					if (yych <= ']') goto yy197;
					if (yych <= '`') goto yy181;
					if (yych <= 'z') goto yy194;
				}
			}
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy204;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 447 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2145 "Zend/zend_ini_scanner.c"
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy204;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == '"') goto yy232;
			goto yy204;
		}
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 502 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2168 "Zend/zend_ini_scanner.c"
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 451 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 2180 "Zend/zend_ini_scanner.c"
yy188:
		YYDEBUG(188, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy185;
			if (yych <= '[') goto yy203;
			goto yy208;
		} else {
			if (yych == '{') goto yy228;
			goto yy203;
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy224;
		}
		goto yy185;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy204;
		if (yych <= '9') goto yy222;
		goto yy204;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy204;
		if (yych <= '9') goto yy220;
		goto yy204;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy193;
				if (yych <= '\f') goto yy204;
			} else {
				if (yych == '"') goto yy193;
				if (yych <= '&') goto yy204;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy216;
				if (yych <= '/') goto yy204;
				goto yy218;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy204;
				} else {
					if (yych != ']') goto yy204;
				}
			}
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 425 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 2246 "Zend/zend_ini_scanner.c"
yy194:
		YYDEBUG(194, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy214;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy204;
			} else {
				if (yych <= '\r') goto yy195;
				if (yych <= '!') goto yy204;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy204;
			} else {
				if (yych <= ';') goto yy195;
				if (yych != ']') goto yy204;
			}
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 421 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 2276 "Zend/zend_ini_scanner.c"
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy203;
yy197:
		YYDEBUG(197, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy200;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 346 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2295 "Zend/zend_ini_scanner.c"
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy200:
		YYDEBUG(200, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy199;
		}
		if (yych == '\n') goto yy201;
		if (yych == '\r') goto yy202;
		goto yy198;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy198;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy201;
		goto yy198;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy204:
		YYDEBUG(204, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy203;
		}
		if (yych == '$') goto yy206;
		if (yych != '\\') goto yy182;
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy203;
yy206:
		YYDEBUG(206, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy207;
			if (yych <= '[') goto yy203;
			goto yy208;
		} else {
			if (yych != '{') goto yy203;
		}
yy207:
		YYDEBUG(207, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy182;
			} else {
				goto yy185;
			}
		} else {
			if (yyaccept <= 2) {
				goto yy193;
			} else {
				goto yy195;
			}
		}
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy209;
		}
		if (yych == '\\') goto yy211;
		goto yy203;
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy209;
		}
		if (yych == '\\') goto yy213;
		goto yy203;
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(212, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy209;
		}
		if (yych == '\\') goto yy211;
		goto yy203;
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy209;
		}
		if (yych == '\\') goto yy211;
		goto yy203;
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy214;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy195;
				if (yych <= '\f') goto yy203;
				goto yy195;
			} else {
				if (yych == '"') goto yy195;
				if (yych <= '#') goto yy203;
				goto yy206;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy195;
				if (yych <= ':') goto yy203;
				goto yy195;
			} else {
				if (yych <= '[') goto yy203;
				if (yych <= '\\') goto yy205;
				if (yych <= ']') goto yy195;
				goto yy203;
			}
		}
yy216:
		YYDEBUG(216, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy216;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy193;
				if (yych <= '\f') goto yy203;
				goto yy193;
			} else {
				if (yych == '"') goto yy193;
				if (yych <= '#') goto yy203;
				goto yy206;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy193;
				if (yych <= ':') goto yy203;
				goto yy193;
			} else {
				if (yych <= '[') goto yy203;
				if (yych <= '\\') goto yy205;
				if (yych <= ']') goto yy193;
				goto yy203;
			}
		}
yy218:
		YYDEBUG(218, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy203;
					goto yy193;
				} else {
					if (yych == '\r') goto yy193;
					goto yy203;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy193;
					goto yy203;
				} else {
					if (yych <= '$') goto yy206;
					if (yych <= '&') goto yy203;
					goto yy193;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy203;
					goto yy216;
				} else {
					if (yych <= '/') goto yy203;
					if (yych <= '9') goto yy218;
					goto yy203;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy193;
					goto yy203;
				} else {
					if (yych <= '\\') goto yy205;
					if (yych <= ']') goto yy193;
					goto yy203;
				}
			}
		}
yy220:
		YYDEBUG(220, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy193;
				if (yych <= '\f') goto yy203;
				goto yy193;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy203;
					goto yy193;
				} else {
					if (yych == '$') goto yy206;
					goto yy203;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy193;
				if (yych <= '/') goto yy203;
				if (yych <= '9') goto yy220;
				goto yy203;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy193;
					goto yy203;
				} else {
					if (yych <= '\\') goto yy205;
					if (yych <= ']') goto yy193;
					goto yy203;
				}
			}
		}
yy222:
		YYDEBUG(222, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy193;
				if (yych <= '\f') goto yy203;
				goto yy193;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy203;
					goto yy193;
				} else {
					if (yych == '$') goto yy206;
					goto yy203;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy193;
				if (yych <= '/') goto yy203;
				if (yych <= '9') goto yy222;
				goto yy203;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy193;
					goto yy203;
				} else {
					if (yych <= '\\') goto yy205;
					if (yych <= ']') goto yy193;
					goto yy203;
				}
			}
		}
yy224:
		YYDEBUG(224, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(225, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy224;
		}
		YYDEBUG(226, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(227, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 337 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2616 "Zend/zend_ini_scanner.c"
yy228:
		YYDEBUG(228, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(229, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 367 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 2627 "Zend/zend_ini_scanner.c"
yy230:
		YYDEBUG(230, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(231, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy203;
				if (yych <= '\t') goto yy230;
				if (yych <= '\n') goto yy182;
				goto yy203;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy182;
					goto yy203;
				} else {
					if (yych <= ' ') goto yy230;
					if (yych <= '!') goto yy203;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '$') {
					if (yych <= '#') goto yy203;
					goto yy206;
				} else {
					if (yych == '\'') goto yy182;
					goto yy203;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy182;
					goto yy203;
				} else {
					if (yych <= '\\') goto yy205;
					if (yych <= ']') goto yy182;
					goto yy203;
				}
			}
		}
yy232:
		YYDEBUG(232, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy187;
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			160, 162, 162, 162, 162, 162, 162, 162, 
			162, 176, 128, 162, 162, 128, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			176, 160, 160, 162, 168, 162, 160,  32, 
			160, 160, 162, 162, 162, 162, 162, 162, 
			230, 230, 230, 230, 230, 230, 230, 230, 
			230, 230, 162, 160, 162, 160, 162, 162, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 162, 162, 162, 166, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 160, 162, 160, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
		};
		YYDEBUG(233, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:	goto yy235;
		case '\t':
		case ' ':	goto yy239;
		case '\n':	goto yy241;
		case '\r':	goto yy243;
		case '!':
		case '&':
		case '(':
		case ')':
		case '|':
		case '~':	goto yy244;
		case '"':	goto yy246;
		case '$':	goto yy248;
		case '\'':	goto yy249;
		case '-':	goto yy250;
		case '.':	goto yy251;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy252;
		case ';':	goto yy254;
		case '=':	goto yy255;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy257;
		case 'F':
		case 'f':	goto yy259;
		case 'N':
		case 'n':	goto yy260;
		case 'O':
		case 'o':	goto yy261;
		case 'T':
		case 't':	goto yy262;
		case 'Y':
		case 'y':	goto yy263;
		default:	goto yy237;
		}
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 497 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 2811 "Zend/zend_ini_scanner.c"
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy265;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 443 "Zend/zend_ini_scanner.l"
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2824 "Zend/zend_ini_scanner.c"
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy315;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 470 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
#line 2837 "Zend/zend_ini_scanner.c"
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 415 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2850 "Zend/zend_ini_scanner.c"
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy313;
		goto yy242;
yy244:
		YYDEBUG(244, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy312;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 433 "Zend/zend_ini_scanner.l"
		{ /* Boolean operators */
	return yytext[0];
}
#line 2868 "Zend/zend_ini_scanner.c"
yy246:
		YYDEBUG(246, *YYCURSOR);
		++YYCURSOR;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 451 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 2880 "Zend/zend_ini_scanner.c"
yy248:
		YYDEBUG(248, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy236;
			if (yych <= '[') goto yy264;
			goto yy271;
		} else {
			if (yych == '{') goto yy309;
			goto yy264;
		}
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy305;
		}
		goto yy236;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy265;
		if (yych <= '9') goto yy303;
		goto yy265;
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy265;
		if (yych <= '9') goto yy301;
		goto yy265;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '.') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy265;
				} else {
					if (yych <= '\n') goto yy253;
					if (yych <= '\f') goto yy265;
				}
			} else {
				if (yych <= '%') {
					if (yych <= 0x1F) goto yy265;
					if (yych >= '#') goto yy265;
				} else {
					if (yych <= ')') goto yy253;
					if (yych <= '-') goto yy265;
					goto yy297;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= '9') {
					if (yych <= '/') goto yy265;
					goto yy299;
				} else {
					if (yych != ';') goto yy265;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '=') goto yy253;
					if (yych <= '{') goto yy265;
				} else {
					if (yych != '~') goto yy265;
				}
			}
		}
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 425 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 2960 "Zend/zend_ini_scanner.c"
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy293;
yy255:
		YYDEBUG(255, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(256, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 437 "Zend/zend_ini_scanner.l"
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 2977 "Zend/zend_ini_scanner.c"
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy266;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy258;
				if (yych <= 0x08) goto yy265;
				if (yych >= '\v') goto yy265;
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy265;
				} else {
					if (yych <= '"') goto yy258;
					if (yych <= '%') goto yy265;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych == ';') goto yy258;
				if (yych <= '<') goto yy265;
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy265;
				} else {
					if (yych != '~') goto yy265;
				}
			}
		}
yy258:
		YYDEBUG(258, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 421 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 3017 "Zend/zend_ini_scanner.c"
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					goto yy265;
				} else {
					if (yych <= '9') goto yy266;
					if (yych == ';') goto yy258;
					goto yy265;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy258;
					if (yych <= '@') goto yy265;
					goto yy289;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych <= 'a') goto yy289;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					if (yych <= '\n') goto yy258;
					goto yy265;
				} else {
					if (yych <= '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					if (yych <= '"') goto yy258;
					goto yy265;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					if (yych <= '9') goto yy266;
					goto yy265;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy258;
						goto yy265;
					} else {
						if (yych <= '=') goto yy258;
						if (yych <= '@') goto yy265;
						goto yy266;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy285;
					if (yych == 'U') goto yy286;
					goto yy266;
				} else {
					if (yych == '_') goto yy266;
					if (yych <= '`') goto yy265;
					goto yy266;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy285;
					if (yych == 'u') goto yy286;
					goto yy266;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy265;
						goto yy258;
					} else {
						if (yych == '~') goto yy258;
						goto yy265;
					}
				}
			}
		}
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					if (yych <= '\n') goto yy258;
					goto yy265;
				} else {
					if (yych <= '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					if (yych <= '"') goto yy258;
					goto yy265;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					if (yych <= '9') goto yy266;
					goto yy265;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy258;
						goto yy265;
					} else {
						if (yych <= '=') goto yy258;
						if (yych <= '@') goto yy265;
						goto yy266;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy280;
					if (yych == 'N') goto yy274;
					goto yy266;
				} else {
					if (yych == '_') goto yy266;
					if (yych <= '`') goto yy265;
					goto yy266;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy280;
					if (yych == 'n') goto yy274;
					goto yy266;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy265;
						goto yy258;
					} else {
						if (yych == '~') goto yy258;
						goto yy265;
					}
				}
			}
		}
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'R') {
					if (yych <= '@') goto yy265;
					if (yych <= 'Q') goto yy266;
					goto yy278;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy278;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy263:
		YYDEBUG(263, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'E') {
					if (yych <= '@') goto yy265;
					if (yych <= 'D') goto yy266;
					goto yy268;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy268;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy264:
		YYDEBUG(264, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy265:
		YYDEBUG(265, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy264;
		}
		if (yych == '$') goto yy269;
		goto yy238;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(267, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy266;
		}
		if (yych <= '%') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy258;
					goto yy264;
				} else {
					if (yych <= '\n') goto yy258;
					if (yych <= '\f') goto yy264;
					goto yy258;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy264;
					goto yy258;
				} else {
					if (yych == '$') goto yy269;
					goto yy264;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= ')') goto yy258;
					goto yy264;
				} else {
					if (yych == '<') goto yy264;
					goto yy258;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy264;
					goto yy258;
				} else {
					if (yych == '~') goto yy258;
					goto yy264;
				}
			}
		}
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'S') {
					if (yych <= '@') goto yy265;
					if (yych <= 'R') goto yy266;
					goto yy274;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy274;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy269:
		YYDEBUG(269, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy270;
			if (yych <= '[') goto yy264;
			goto yy271;
		} else {
			if (yych != '{') goto yy264;
		}
yy270:
		YYDEBUG(270, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy238;
				} else {
					goto yy240;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy236;
				} else {
					goto yy253;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept <= 4) {
					goto yy258;
				} else {
					goto yy275;
				}
			} else {
				goto yy282;
			}
		}
yy271:
		YYDEBUG(271, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy272;
		}
		goto yy264;
yy272:
		YYDEBUG(272, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(273, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy272;
		}
		if (yych <= 0x00) goto yy238;
		if (yych == '\\') goto yy271;
		goto yy264;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy276;
		}
		if (yych <= ';') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy275;
					if (yych <= '\t') goto yy265;
				} else {
					if (yych != '\r') goto yy265;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy275;
					if (yych <= '%') goto yy265;
				} else {
					if (yych <= '/') goto yy265;
					if (yych <= '9') goto yy266;
					if (yych <= ':') goto yy265;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') {
					if (yych != '=') goto yy265;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych <= '^') goto yy265;
					goto yy266;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy265;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych >= 0x7F) goto yy265;
				}
			}
		}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 381 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 3513 "Zend/zend_ini_scanner.c"
yy276:
		YYDEBUG(276, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(277, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy276;
		}
		goto yy275;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'U') {
					if (yych <= '@') goto yy265;
					if (yych <= 'T') goto yy266;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy279;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'E') {
					if (yych <= '@') goto yy265;
					if (yych <= 'D') goto yy266;
					goto yy274;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy274;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'F') {
					if (yych <= '@') goto yy265;
					if (yych <= 'E') goto yy266;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy281;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy266;
		}
		if (yych <= '%') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy265;
				} else {
					if (yych <= '\t') goto yy283;
					if (yych >= '\v') goto yy265;
				}
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy265;
				} else {
					if (yych <= ' ') goto yy283;
					if (yych >= '#') goto yy265;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych >= '*') goto yy265;
				} else {
					if (yych == '<') goto yy265;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy265;
				} else {
					if (yych != '~') goto yy265;
				}
			}
		}
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 385 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 3717 "Zend/zend_ini_scanner.c"
yy283:
		YYDEBUG(283, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(284, *YYCURSOR);
		if (yych == '\t') goto yy283;
		if (yych == ' ') goto yy283;
		goto yy282;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy282;
					if (yych <= 0x08) goto yy265;
					if (yych <= '\t') goto yy283;
					goto yy282;
				} else {
					if (yych == '\r') goto yy282;
					if (yych <= 0x1F) goto yy265;
					goto yy283;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy282;
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy282;
					goto yy265;
				} else {
					if (yych <= '9') goto yy266;
					if (yych == ';') goto yy282;
					goto yy265;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy282;
					if (yych <= '@') goto yy265;
					if (yych <= 'M') goto yy266;
					goto yy288;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'n') goto yy288;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy282;
					goto yy265;
				}
			}
		}
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'L') {
					if (yych <= '@') goto yy265;
					if (yych <= 'K') goto yy266;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy287;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy287:
		YYDEBUG(287, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'L') {
					if (yych <= '@') goto yy265;
					if (yych <= 'K') goto yy266;
					goto yy281;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy281;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'E') {
					if (yych <= '@') goto yy265;
					if (yych <= 'D') goto yy266;
					goto yy281;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy281;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'L') {
					if (yych <= '@') goto yy265;
					if (yych <= 'K') goto yy266;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy290;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'S') {
					if (yych <= '@') goto yy265;
					if (yych <= 'R') goto yy266;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy291;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy258;
					if (yych <= 0x08) goto yy265;
					goto yy258;
				} else {
					if (yych == '\r') goto yy258;
					if (yych <= 0x1F) goto yy265;
					goto yy258;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy265;
					if (yych <= ')') goto yy258;
					if (yych <= '/') goto yy265;
					goto yy266;
				} else {
					if (yych == ';') goto yy258;
					if (yych <= '<') goto yy265;
					goto yy258;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'E') {
					if (yych <= '@') goto yy265;
					if (yych <= 'D') goto yy266;
					goto yy281;
				} else {
					if (yych <= 'Z') goto yy266;
					if (yych == '_') goto yy266;
					goto yy265;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy281;
					if (yych <= 'z') goto yy266;
					goto yy265;
				} else {
					if (yych == '}') goto yy265;
					if (yych <= '~') goto yy258;
					goto yy265;
				}
			}
		}
yy292:
		YYDEBUG(292, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy293:
		YYDEBUG(293, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy292;
		}
		if (yych >= '\r') goto yy296;
yy294:
		YYDEBUG(294, *YYCURSOR);
		++YYCURSOR;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 484 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 4099 "Zend/zend_ini_scanner.c"
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy294;
		goto yy295;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(298, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy297;
		}
		if (yych <= '%') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy253;
					goto yy264;
				} else {
					if (yych <= '\n') goto yy253;
					if (yych <= '\f') goto yy264;
					goto yy253;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy264;
					goto yy253;
				} else {
					if (yych == '$') goto yy269;
					goto yy264;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= ')') goto yy253;
					goto yy264;
				} else {
					if (yych == '<') goto yy264;
					goto yy253;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy264;
					goto yy253;
				} else {
					if (yych == '~') goto yy253;
					goto yy264;
				}
			}
		}
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(300, *YYCURSOR);
		if (yych <= '-') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy253;
					if (yych <= 0x08) goto yy264;
					goto yy253;
				} else {
					if (yych == '\r') goto yy253;
					goto yy264;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy253;
					if (yych <= '#') goto yy264;
					goto yy269;
				} else {
					if (yych <= '%') goto yy264;
					if (yych <= ')') goto yy253;
					goto yy264;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= '9') {
					if (yych <= '.') goto yy297;
					if (yych <= '/') goto yy264;
					goto yy299;
				} else {
					if (yych == ';') goto yy253;
					goto yy264;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '=') goto yy253;
					if (yych <= '{') goto yy264;
					goto yy253;
				} else {
					if (yych == '~') goto yy253;
					goto yy264;
				}
			}
		}
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(302, *YYCURSOR);
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy253;
					goto yy264;
				} else {
					if (yych <= '\n') goto yy253;
					if (yych <= '\f') goto yy264;
					goto yy253;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy264;
					if (yych <= '"') goto yy253;
					goto yy264;
				} else {
					if (yych <= '$') goto yy269;
					if (yych <= '%') goto yy264;
					goto yy253;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= '9') {
					if (yych <= '/') goto yy264;
					goto yy301;
				} else {
					if (yych == ';') goto yy253;
					goto yy264;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '=') goto yy253;
					if (yych <= '{') goto yy264;
					goto yy253;
				} else {
					if (yych == '~') goto yy253;
					goto yy264;
				}
			}
		}
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(304, *YYCURSOR);
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy253;
					goto yy264;
				} else {
					if (yych <= '\n') goto yy253;
					if (yych <= '\f') goto yy264;
					goto yy253;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy264;
					if (yych <= '"') goto yy253;
					goto yy264;
				} else {
					if (yych <= '$') goto yy269;
					if (yych <= '%') goto yy264;
					goto yy253;
				}
			}
		} else {
			if (yych <= '<') {
				if (yych <= '9') {
					if (yych <= '/') goto yy264;
					goto yy303;
				} else {
					if (yych == ';') goto yy253;
					goto yy264;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '=') goto yy253;
					if (yych <= '{') goto yy264;
					goto yy253;
				} else {
					if (yych == '~') goto yy253;
					goto yy264;
				}
			}
		}
yy305:
		YYDEBUG(305, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(306, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy305;
		}
		YYDEBUG(307, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(308, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 337 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 4320 "Zend/zend_ini_scanner.c"
yy309:
		YYDEBUG(309, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(310, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 367 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 4331 "Zend/zend_ini_scanner.c"
yy311:
		YYDEBUG(311, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy312:
		YYDEBUG(312, *YYCURSOR);
		if (yych == '\t') goto yy311;
		if (yych == ' ') goto yy311;
		goto yy245;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy242;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy315:
		YYDEBUG(315, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy240;
				if (yych <= '\t') goto yy314;
				goto yy313;
			} else {
				if (yych == '\r') goto yy317;
				goto yy240;
			}
		} else {
			if (yych <= '"') {
				if (yych <= ' ') goto yy314;
				if (yych <= '!') goto yy240;
			} else {
				if (yych == ';') goto yy292;
				goto yy240;
			}
		}
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy247;
yy317:
		YYDEBUG(317, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy313;
		goto yy242;
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0, 128,   0,   0, 128, 128,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(318, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= ',') {
				if (yych == '*') goto yy323;
				goto yy321;
			} else {
				if (yych == '/') goto yy321;
				if (yych <= '9') goto yy323;
				goto yy321;
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy323;
				if (yych == '_') goto yy323;
				goto yy321;
			} else {
				if (yych <= 'z') goto yy323;
				if (yych == '}') goto yy324;
				goto yy321;
			}
		}
yy320:
		YYDEBUG(320, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 372 "Zend/zend_ini_scanner.l"
		{ /* Variable name */
	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
#line 4448 "Zend/zend_ini_scanner.c"
yy321:
		YYDEBUG(321, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(322, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 502 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 4458 "Zend/zend_ini_scanner.c"
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy327;
yy324:
		YYDEBUG(324, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(325, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 376 "Zend/zend_ini_scanner.l"
		{ /* Variable end */
	yy_pop_state(TSRMLS_C);
	return '}';
}
#line 4473 "Zend/zend_ini_scanner.c"
yy326:
		YYDEBUG(326, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy327:
		YYDEBUG(327, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy326;
		}
		goto yy320;
	}
}
#line 506 "Zend/zend_ini_scanner.l"

}
