--TEST--
apache_request_headers() stack overflow.
--SKIPIF--
<?php 
include "skipif.inc"; 
?>
--FILE--
<?php
include "include.inc";

$php = get_cgi_path();
reset_env_vars();

$file = dirname(__FILE__)."/012.test.php";

file_put_contents($file, '<?php print_r(apache_request_headers()); ?>');

passthru("$php $file");

$names = array('HTTP_X_TEST', 'HTTP_X__TEST', 'HTTP_X_');
foreach ($names as $name) {
	putenv($name."=".str_repeat("A", 256));
	passthru("$php -q $file");
	putenv($name);
}
unlink($file);

echo "Done\n";
?>
--EXPECTF--	
X-Powered-By: PHP/%s
Content-type: text/html

Array
(
)
Array
(
    [X-Test] => AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
)
Array
(
    [X--Test] => AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
)
Array
(
    [X-] => AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
)
Done
